/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module;

import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.handler.ModuleHandler;
import svenhjol.charm.base.helper.EnchantmentsHelper;
import svenhjol.charm.base.helper.PlayerHelper;
import svenhjol.charm.base.iface.Module;
import svenhjol.charm.enchantment.AcquisitionEnchantment;

@Module(mod="charm", description="Tools with the Acquisition enchantment automatically pick up drops.")
public class Acquisition
extends CharmModule {
    private static final ThreadLocal<PlayerEntity> breakingPlayer = new ThreadLocal();
    public static AcquisitionEnchantment ACQUISITION;

    @Override
    public void register() {
        ACQUISITION = new AcquisitionEnchantment(this);
    }

    public static void startBreaking(PlayerEntity player, ItemStack tool) {
        if (ModuleHandler.enabled(Acquisition.class) && EnchantmentsHelper.has(tool, ACQUISITION)) {
            breakingPlayer.set(player);
        }
    }

    public static void stopBreaking() {
        breakingPlayer.remove();
    }

    public static boolean trySpawnToInventory(World world, ItemStack stack) {
        PlayerEntity player;
        if (!world.field_72995_K && !stack.func_190926_b() && world.func_82736_K().func_223586_b(GameRules.field_223603_f) && !world.restoringBlockSnapshots && (player = breakingPlayer.get()) != null) {
            PlayerHelper.addOrDropStack(player, stack);
            return true;
        }
        return false;
    }

    public static boolean trySpawnToInventory(PlayerEntity player, ItemStack tool, List<ItemStack> stacks) {
        if (ModuleHandler.enabled(Acquisition.class) && EnchantmentsHelper.has(tool, ACQUISITION)) {
            stacks.forEach(it -> PlayerHelper.addOrDropStack(player, it));
            return true;
        }
        return false;
    }
}

